/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.util.JsonHelper;

public class NamedComponentRegistry<T> {
    private final BiMap<class_2960, T> values = HashBiMap.create();
    private final String errorText;

    public NamedComponentRegistry(String errorText) {
        this.errorText = errorText + " ";
    }

    public <V extends T> V register(class_2960 name, V value) {
        if (this.values.putIfAbsent((Object)name, value) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return value;
    }

    @Nullable
    public T getValue(class_2960 name) {
        return (T)this.values.get((Object)name);
    }

    @Nullable
    public class_2960 getOptionalKey(T value) {
        return (class_2960)this.values.inverse().get(value);
    }

    public class_2960 getKey(T value) {
        class_2960 key = this.getOptionalKey(value);
        if (key == null) {
            throw new IllegalStateException(this.errorText + value);
        }
        return key;
    }

    private T deserialize(class_2960 name) {
        T value = this.getValue(name);
        if (value == null) {
            throw new JsonSyntaxException(this.errorText + name);
        }
        return value;
    }

    public T convert(JsonElement element, String key) {
        return this.deserialize(JsonHelper.convertToResourceLocation(element, key));
    }

    public T deserialize(JsonObject parent, String key) {
        return this.deserialize(JsonHelper.getResourceLocation(parent, key));
    }

    public void toNetwork(T value, class_2540 buffer) {
        buffer.method_10812(this.getKey(value));
    }

    public void toNetworkOptional(@Nullable T value, class_2540 buffer) {
        if (value != null) {
            buffer.method_10814(this.getKey(value).toString());
        } else {
            buffer.method_10814("");
        }
    }

    private T fromNetwork(class_2960 name) {
        T value = this.getValue(name);
        if (value == null) {
            throw new DecoderException(this.errorText + name);
        }
        return value;
    }

    public T fromNetwork(class_2540 buffer) {
        return this.fromNetwork(buffer.method_10810());
    }

    @Nullable
    public T fromNetworkOptional(class_2540 buffer) {
        String key = buffer.method_10800(Short.MAX_VALUE);
        if (key.isEmpty()) {
            return null;
        }
        return this.fromNetwork(new class_2960(key));
    }
}

